/******************************************************************************
Copyright (c) 2009-2013 TP-Link Technologies CO.,LTD.  All rights reserved. 

File name	: br_deliver.h
Version		: v1.0, release version
Description	: This file defines the dual wifi repeater connection functions
		  for some dual band repeaters, such as wa3500re(EU) 1.0.
 
Author		: huanglifu <huanglifu@tp-link.net>
Create date	: 2013/5/27

History		:
01, 2013/05/27 huanglifu, Created file.
02, 2013/09/23 tengfei, Modify file name and some descriptions to remove info
	       related special product(wda3150).
03, 2014/07/11 Zhou Guofeng ,add the proc file for naming the devive ,debug  and 
              fix the bug that block in-loop packet
*****************************************************************************/
#ifndef __TP_DELIVER_H
#define __TP_DELIVER_H

#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/inetdevice.h>
#include "br_private.h"

//#define BRIDGE_DELIVER_DEBUG_ON_OFF
//#ifdef BRIDGE_DELIVER_DEBUG_ON
#define REPEATER_PRINT(args) do{if(g_range_extender_dbg)printk args;}while(0)
//#else
//#define REPEATER_PRINT(args) do{printk args;}while(0)
//#endif

/*RE Repeater 豸*/

#define BRIDGE_DELIVER_DEV_NAME_LEN  10
#define BRIDGE_DELIVER_DEV_NUM	 6
#define BRIDGE_DELIVER_DEV_MAX_SIZE BRIDGE_DELIVER_DEV_NAME_LEN*BRIDGE_DELIVER_DEV_NUM

#define BRIDGE_DELIVER_2G_DEV_NAME g_name_matrix[0]
#define BRIDGE_DELIVER_5G_DEV_NAME g_name_matrix[1]
#define BRIDGE_DELIVER_LAN_ETH_NAME g_name_matrix[2]
#define BRIDGE_DELIVER_NAME g_name_matrix[3]
#define BRIDGE_DELIVER_2G_STA_NAME g_name_matrix[4]
#define BRIDGE_DELIVER_5G_STA_NAME g_name_matrix[5]


#define MAX_BACK_DEV_BR_INDEX_VALUE 4

#define DUAL_REPEATER_HAS_NONE_FROMT_DUT 0
#define DUAL_REPEATER_HAS_SAME_FROMT_DUT 1
#define DUAL_REPEATER_HAS_TWO_FROMT_DUT 2

/*豸ֵɹ˱С*/
#define MAX_DEV_IFINDEX_VALUE 10
/* tp double frequence forward info table */
struct tp_db_fre_bridge_fdb_entry 
{
    int is_enabled;              //¼ñǷЧûã˫ƵwispģʽΪ1Ϊ0
    int link_state;				 //ģʱ޸ĸ״̬¼2/5g·״̬Ƿbrת豸ѡʱõ״̬
	int eth_goto_2g_flag;		 //¼߿ڼűǰDUTͨŵ·2G5G.
	int is_same_front_dut;	     //ڱ˫ƵRepeaterǷͬʱӵͬһǰ·
		
    int ap_dev_2g_idx;           //¼ap2G豸ra0
    int ap_dev_5g_idx;           //¼ap5G豸ra1
    int client_dev_2g_idx;       //¼clinent2G豸cli0
    int client_dev_5g_idx;       //¼clinent5G豸cli1
    int eth_dev_idx;		 	 //¼ap豸eth2.1
    int br0_dev_idx;			 //¼ap豸br0
    
    struct 	net_device* client_2g_dev; //¼clinent2G豸ָ
	struct 	net_device* client_5g_dev; //¼clinent5G豸ָ
	struct 	net_device* br0_dev;	   //¼豸ָ
	struct 	net_device* eth_dev;	   //¼Eth0 豸ָ
	struct 	net_bridge*  br0_bri_dev;	//¼豸ָ
		
    char filter_table_2g_5g[MAX_DEV_IFINDEX_VALUE][MAX_DEV_IFINDEX_VALUE]; //˫Ƶ2G&5Gת˱
    char filter_table_only_2g[MAX_DEV_IFINDEX_VALUE][MAX_DEV_IFINDEX_VALUE];//˫Ƶ2Gת˱
    char filter_table_only_5g[MAX_DEV_IFINDEX_VALUE][MAX_DEV_IFINDEX_VALUE];//˫Ƶ5Gת˱
    char filter_table_none[MAX_DEV_IFINDEX_VALUE][MAX_DEV_IFINDEX_VALUE];
};

enum TP_LINK_STATE
{
	LINK_STATE_OFF = 0,
	LINK_STATE_ON  = 1,
};
enum TP_LINK_STATE_TYPE
{
	LINK_STATE_NONE = 0,
	LINK_STATE_ONLY_2G = 2,
	LINK_STATE_ONLY_5G = 4,
	LINK_STATE_ALL_2G_5G = LINK_STATE_ONLY_2G | LINK_STATE_ONLY_5G,
};

/*豸*/
#define GET_DEV_INDEX_BY_NAME(tmpDev, devIndex, NAME) \
	do{\
		if (NULL == NAME)\
		{\
			printk("bridge ERROR: NULL name\n");\
			goto INIT_FAIL;\
		}\
		tmpDev = dev_get_by_name(&init_net, NAME);\
		if (NULL != tmpDev)\
		{\
			br_sub_dev_index_count++;\
			tmpDev->br_port_index = devIndex = br_sub_dev_index_count;\
			REPEATER_PRINT(("%s %d dev name = %s, br_port_index = %d\n", __FUNCTION__, __LINE__, tmpDev->name, devIndex));\
			if (MAX_DEV_IFINDEX_VALUE <= devIndex)\
			{\
				printk("%s %d dev name = %s br_port_index to large.\n", __FUNCTION__, __LINE__, tmpDev->name);\
				dev_put(tmpDev);\
				goto INIT_FAIL;\
			}\
			dev_put(tmpDev);\
		}\
		else\
		{\
			printk("%s %d dev name = %s is not exist.\n", __FUNCTION__, __LINE__, NAME);\
			goto INIT_FAIL;\
		}\
	}while(0)
	
/*豸*/
#define GET_DEV_BY_NAME(Dev, NAME) \
	do{\
		Dev = dev_get_by_name(&init_net, NAME);\
		if (NULL == Dev)\
		{\
			printk("%s %d dev name = %s is not exist.\n", __FUNCTION__, __LINE__, NAME);\
			goto INIT_FAIL;\
		}\
		dev_put(Dev);\
	}while(0)

#define CHECK_AND_INIT_TABLE(ret) \
	do{\
		if (LINK_STATE_OFF == g_range_extender_bridge_deliver_enable) \
		{\
			return ret;\
		}\
		\
		if (LINK_STATE_OFF == p->is_enabled)\
		{\
			if (LINK_STATE_OFF == init_free_bridge_fdb())\
			{\
				return ret;\
			}\
		}\
	}while(0)
/*ȡproc*/
#define GET_PROC_VAR_VALUE(var) \
	do{\
	return sprintf (page, "%d\n", var);\
	}while(0)

/*proc*/
#define SET_PROC_VAR_VALUE(var)\
	do{\
		u_int32_t val;\
		\
		if (sscanf(buf, "%d", &val) != 1)\
	        return -EINVAL;\
		\
		if ((val < 0) || (val > 1))\
		{\
			return -EINVAL;\
		}\
		var = val;\
	}while(0)
	
/*ݲͬĹ˱ȡǰӦ˹*/
#define IS_DEV_FILTERED(table, pSrc, pDst) (table[pSrc->br_port_index][pDst->br_port_index] == 1)
/*豸˱ֵ*/
#define FILTER_SET_VALUE_ON(table, srcIdx, DstIdx) 	table[srcIdx][DstIdx] = 1;
/*ݱ־λ2G or 5GӦ*/
#define GET_2G_5G_DEV_INDEX_BY_FLAG(flag, client_dev_5g_idx, client_dev_2g_idx) (flag == 1 ? client_dev_5g_idx : client_dev_2g_idx)



int  create_range_extender_config_proc(void);
int  br_db_fre_should_deliver(struct net_bridge_port *to, struct sk_buff *skb);
int  br_db_fre_fdb_lookup(struct net_bridge_port **to, struct sk_buff *skb);
int  br_should_deliver_packet(struct sk_buff *skb);
unsigned br_fdb_update_mapped_hwaddr(struct net_bridge *br, struct net_bridge_port *source,
		  struct sk_buff *skb);

#endif //__TP_DELIVER_H
